package coreservlets;

import javax.servlet.http.*;
import org.apache.struts.action.*;

/** Komponent bean zawierajcy pola wyznaczajce format yciorysu.
 *  ActionMessages zawiera dodatkowe argumenty uywane w sparametryzowanych
 *  komunikatach zdefiniowanych w pliku waciwoci.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class FormatFormBean extends ActionForm {
  private String titleSize = "";
  private String headingSize = "";
  private String bodySize = "";
  private String bgColor = "";
  private String fgColor = "";

  public String getTitleSize() {
    return(titleSize);
  }

  public void setTitleSize(String titleSize) {
    this.titleSize = titleSize;
  }

  public String getHeadingSize() {
    return(headingSize);
  }

  public void setHeadingSize(String headingSize) {
    this.headingSize = headingSize;
  }

  public String getBodySize() {
    return(bodySize);
  }

  public void setBodySize(String bodySize) {
    this.bodySize = bodySize;
  }

  public String getBgColor() {
    return(bgColor);
  }

  public void setBgColor(String bgColor) {
    this.bgColor = bgColor;
  }

  public String getFgColor() {
    return(fgColor);
  }

  public void setFgColor(String fgColor) {
    this.fgColor = fgColor;
  }

  public String getStyleSheet() {
    return(
      "<STYLE TYPE=\"text/css\">\n" +
      "<!--\n" +
      "H1 { font-size: " + titleSize + "px; }\n" +
      "H2 { font-size: " + headingSize + "px; }\n" +
      "BODY { font-size: " + bodySize + "px;\n" +
      "       background-color: " + bgColor + ";\n" +
      "       color: " + fgColor + "; }\n" +
      "-->\n" +
      "</STYLE>");
    }

  public ActionErrors validate(ActionMapping mapping,
                               HttpServletRequest request) {
    ActionErrors errors = new ActionErrors();
    if (isMissing(getTitleSize())) {
      errors.add("titleSizeMissing",
                 new ActionMessage("value.required",
                                   "Rozmiar tytuu"));
    } else if (!isInt(getTitleSize())) {
      errors.add("titleNotInt",
                 new ActionMessage("value.int",
                                   "Rozmiar tytuu",
                                   getTitleSize()));
    }
    if (isMissing(getHeadingSize())) {
      errors.add("headingSizeMissing",
                 new ActionMessage("value.required",
                                   "Rozmiar nagwka"));
    } else if (!isInt(getHeadingSize())) {
      errors.add("headingNotInt",
                 new ActionMessage("value.int",
                                   "Rozmiar nagwka",
                                    getHeadingSize()));
    }
    if (isMissing(getBodySize())) {
      errors.add("bodySizeMissing",
                 new ActionMessage("value.required",
                                   "Rozmiar tekstu"));
    } else if (!isInt(getBodySize())) {
      errors.add("bodyNotInt",
                 new ActionMessage("value.int",
                                   "Rozmiar tekstu",
                                   getBodySize()));
    }
    if (isMissing(getBgColor())) {
      errors.add("bgColorMissing",
                 new ActionMessage("value.required",
                                   "Kolor ta"));
    }
    if (isMissing(getFgColor())) {
      errors.add("fgColorMissing",
                 new ActionMessage("value.required",
                                   "Kolor pierwszoplanowy"));
    } else if (getBgColor().equals(getFgColor())) {
      errors.add("colorsIdentical",
                 new ActionMessage("colors.match",
                                   getBgColor()));
    }
    return(errors);
  }

  private boolean isMissing(String value) {
      return((value == null) || (value.trim().equals("")));
  }

  private boolean isInt(String potentialInt) {
    boolean isInt = true;
    try {
      int x = Integer.parseInt(potentialInt);
    } catch(NumberFormatException nfe) {
      isInt = false;
    }
    return(isInt);
  }
}
